<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use App\Mail\SendOtpMail;

class AuthController extends Controller
{
    public function sendOtp(Request $request)
    {
         $request->validate(['phone' => 'required']);

            $phone = $request->phone;

            // Check if user already exists
            $user = User::where('mobile', $phone)->first();

            if (!$user) {
                return back()->withErrors(['error' => 'This phone number is not registered.']);
            }

            $otp = rand(100000, 999999);
            DB::table('otps')->updateOrInsert(
        ['phone' => $request->phone],
        ['otp' => $otp, 'updated_at' => now(), 'created_at' => now()]
    );

    // Call MSG91 or send the $otp to the phone
    // (Same as you had earlier)

    session(['phone' => $request->phone]);

    return redirect()->route('verify.show')->with('status', 'OTP sent successfully!');
    }

    public function showVerifyOtp()
    {
        return view('auth.verify-otp');
    }

    public function verifyOtp(Request $request)
    {
        $request->validate(['otp' => 'required|numeric']);
    $phone = session('phone');

    // Get user
    $user = User::where('mobile', $phone)->first();
    if (!$user) {
        return back()->withErrors(['error' => 'User not found.']);
    }

    // Get OTP record
    $otpRecord = DB::table('otps')->where('phone', $phone)->first();

    if (!$otpRecord || $otpRecord->otp != $request->otp) {
        return back()->withErrors(['error' => 'Invalid OTP']);
    }

    // Everything is okay ➔ Log in
    Auth::login($user);

    // Optionally delete the used OTP
    DB::table('otps')->where('phone', $phone)->delete();

    session()->forget('phone');

    return redirect('/dashboard')->with('status', "Logged in as {$user->name} ({$user->email})");
    }

// FUNCTION FOR EMAIL otp
    public function sendEmailOtp(Request $request)
        {
            $request->validate(['email' => 'required|email']);
                $user = User::where('email', $request->email)->first();

                if (!$user) {
                    return back()->withErrors(['error' => 'This email is not registered.']);
                }

                $otp = rand(100000, 999999);

                // Save in the mail_otps table
                DB::table('mail_otps')->updateOrInsert(
                    ['email' => $user->email],
                    [
                        'otp' => $otp,
                        'updated_at' => now(),
                        'created_at' => now()
                    ]
                );

                // Send the email
                Mail::to($user->email)->send(new SendOtpMail($otp));

                // Save email in session
                session(['email' => $user->email]);

                return redirect()->route('verify.show')->with('status', 'OTP sent to your email!');
        }


        public function showmailVerifyOtp()
            {
                return view('auth.verify-otp');
            }

        public function verifymailOtp(Request $request)
        {
            $request->validate(['otp' => 'required|numeric']);
            $email = session('email');

            $user = User::where('email', $email)->first();
            if (!$user) {
                return back()->withErrors(['error' => 'User not found.']);
            }

            $otpRecord = DB::table('mail_otps')->where('email', $email)->first();

            if (!$otpRecord || $otpRecord->otp != $request->otp) {
                return back()->withErrors(['error' => 'Invalid OTP']);
            }

            Auth::login($user);
            DB::table('mail_otps')->where('email', $email)->delete();
            session()->forget('email');

            return redirect('/dashboard')->with('status', "Logged in as {$user->name}");
        }


}
