<?php

namespace App\Http\Controllers;
use App\Models\member;
use App\Models\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

use Illuminate\Http\Request;

class memberController extends Controller
{
    public function import(Request $request)
    {
                $request->validate([
                    'user_file' => 'required|mimes:csv,txt',
                ]);

            $handle = fopen($request->file('user_file')->getRealPath(), 'r');

            while (($row = fgetcsv($handle)) !== false) {
                

                DB::table('users')->insert([
                    'name' => $row[0],
                    'email' => $row[1],
                    'mobile' => $row[2],
                    'password' => Hash::make($row[3]),
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }

            fclose($handle);

            return back()->with('success', 'Import Complete!');
    }

   public function member_details(Request $req)
   {

     $search = $req->input('search');

    if ($search) {
        $members = member::where('name', 'like', '%' . $search . '%')->get();
    } else {
        $members = member::all();
    }

    return view('dashboard', compact('members', 'search'));
     //    $members = Member::all();

     //    // Pass to the view
     //    return view('dashboard', compact('members'));
   }
   public function show($id){
    $member = DB::table('members')
    ->leftJoin('user_profiles', 'members.email', '=', 'user_profiles.email')
    ->select('members.*', 'user_profiles.profile') // uses 'profile' directly
    ->where('members.id', $id)
    ->first();

return view('details', compact('member'));
        // $member = Member::findOrFail($id);
        // $user = User::where('email', $member->email)->get();
        // return view('details', compact('member','user'));
   }
}
