<x-guest-layout>
    <!-- Session Status -->
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <!-- Toggle Buttons -->
    <div class="flex justify-center space-x-4 mt-4">
        <button id="emailBtn" type="button" class="px-4 py-2 rounded bg-gray-200">Email/Password</button>
        {{-- <button id="otpBtn" type="button" class="px-4 py-2 rounded bg-gray-200">Log-In-WhatsApp OTP</button> --}}
        <button id="otpBtn" type="button" class="px-4 py-2 rounded bg-gray-200">Log-In E-Mail OTP</button>
    </div>

    <!-- Email/Password Form -->
    <form id="emailForm" method="POST" action="{{ route('login') }}" class="mt-4">
        @csrf
        <div>
            <x-input-label for="email" :value="__('Email')" />
            <x-text-input id="email" class="block mt-1 w-full" 
                           type="email" name="email" :value="old('email')" required autofocus 
                           autocomplete="username" />
            <x-input-error :messages="$errors->get('email')" class="mt-2" />
        </div>

        <div class="mt-4">
            <x-input-label for="password" :value="__('Password')" />
            <x-text-input id="password" class="block mt-1 w-full" 
                           type="password" name="password" required 
                           autocomplete="current-password" />
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <div class="block mt-4">
            <label for="remember_me" class="inline-flex items-center">
                <input id="remember_me" type="checkbox" 
                       class="rounded dark:bg-gray-900 border-gray-300 dark:border-gray-700 text-indigo-600 shadow-sm focus:ring-indigo-500 dark:focus:ring-indigo-600 dark:focus:ring-offset-gray-800" 
                       name="remember">
                <span class="ml-2 text-sm text-gray-600 dark:text-gray-400">Remember me</span>
            </label>
        </div>

        <div class="flex items-center justify-end mt-4">
            @if (Route::has('password.request'))
                <a class="underline text-sm text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-gray-100 rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500 dark:focus:ring-offset-gray-800" 
                   href="{{ route('password.request') }}">
                    Forgot your password?
                </a>
            @endif

            <x-primary-button class="ml-3">
                Log in
            </x-primary-button>
        </div>
    </form>

    <!-- WhatsApp OTP Login Form -->
    {{-- <form id="otpForm" method="POST" action="{{ route('send.otp') }}" class="mt-4 hidden">
        @csrf
        <div>
            <x-input-label for="phone" :value="__('Phone Number (with country code)')" />
            <x-text-input id="phone" class="block mt-1 w-full" 
                           type="text" name="phone" placeholder="e.g. 919876543210" required />
            <x-input-error :messages="$errors->get('phone')" class="mt-2" />
        </div>
        <div class="flex items-center justify-end mt-4">
            <x-primary-button>Send OTP</x-primary-button>
        </div>
    </form> --}}

     <!-- email OTP Login Form -->

    <form method="POST" id="otpForm" action="{{ route('send.otp') }}" class="mt-4 hidden">
    @csrf
    <div>
        <x-input-label for="phone" :value="__('Login by email OTP')" />
        <input id="email" name="email" type="email" required class="border rounded p-2 w-full block mt-1 " />
    </div>

    <div class="flex items-center justify-end mt-4">
        <x-primary-button>
            Send OTP
        </x-primary-button>
    </div>
</form>

    <!-- Scripts for Toggle -->
    <script>
        const emailBtn = document.getElementById('emailBtn');
        const otpBtn = document.getElementById('otpBtn');
        const emailForm = document.getElementById('emailForm');
        const otpForm = document.getElementById('otpForm');

        emailBtn.addEventListener('click', () => {
            emailForm.classList.remove('hidden');
            otpForm.classList.add('hidden');
        });
        otpBtn.addEventListener('click', () => {
            emailForm.classList.add('hidden');
            otpForm.classList.remove('hidden');
        });
    </script>
</x-guest-layout>
