<x-app-layout>
    @php
        $user=Auth::user();
        
    @endphp
    <x-slot name="header" class="bg-lime-500">
        {{-- <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Dashboard') }}
        </h2> --}}
        <div class="bg-gradient-to-r from-yellow-400 via-orange-400 to-pink-500 py-6 rounded-md shadow-md">
        <h2 class="text-4xl font-extrabold text-center text-white drop-shadow-lg">
            Welcome  {{$user->name}} 
        </h2>
        </div>
    </x-slot>

    <div class="py-2 pb-3">
        <div class="w-100 mx-3 h-auto">
            <div class="bg-lime dark:bg-lime-900 overflow-hidden shadow-2xl rounded-3xl border border-lime-500">
                <div class="p-6 text-gray-900 dark:text-gray-100 text-center">
                    <h2 class="fw-bold text-2xl sm:text-4xl font-semibold  text-dark-700 ">
                        List Rotary Directory
                    </h2>
                    
                </div>
            </div>
        </div>
    </div>
    <div class="py-8 bg-gray-100">
        <div class="flex w-100 justify-end px-4  mb-3 ">
             @if(request('search'))
            <a href="{{ route('dashboard') }}" 
               class="bg-blue-600 hover:bg-blue-700 text-white font-semibold align-items-start py-2 px-4 rounded-3xl">
                 All Members
            </a>
        @endif
            <form method="GET" action="{{ route('dashboard') }}" class="flex mx-2 items-center space-x-2">
                <input type="text" class="rounded-3xl px-4 py-2 border border-black shadow-2xl focus:outline-none focus:ring-2 focus:ring-blue-500 "  placeholder="Search by name" name="search" value=""/>
                <button type="submit" ID class="bg-lime-600 hover:bg-lime-700 text-white font-semibold py-2 px-4 rounded-3xl">
            Search
        </button>
        
            </form>
        </div>
    <div class="container mx-auto px-4">
        <div class="bg-white shadow-lg rounded-lg overflow-hidden">
            <table class="min-w-full table-auto border border-dark">
                <thead class="bg-lime-600 text-white">
                    <tr class="bg-gray-600">
                        <th class="px-6 py-3 text-left text-sm font-bold  uppercase border-r  ">{{ __('Sl. No.') }}</th>
                        <th class="px-6 py-3 text-left text-sm font-bold uppercase border-r border-black">{{ __('NAME') }}</th>
                        <th class="px-6 py-3 text-left text-sm font-bold uppercase border-r border-black">{{ __('ACTION') }}</th>
                    </tr>
                </thead>
                @foreach ($members as $member)
                    
             
                <tbody class="bg-white text-gray-700">
                    <tr class="border-t border-gray-800 hover:bg-orange-300">
                        <td class="px-2 py-4 border-r border-black">{{$member->id}}</td>
                        <td class="px-2 py-4 border-r border-black">{{ $member->name }}</td>
                        <td class="px-2 py-4 border-r border-black"><a href="{{ route('more_details', $member->id) }}" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-4 rounded">View more</a></td>
                        
                    </tr>
                </tbody>
                   @endforeach
            </table>
        </div>
    </div>
</div>
</x-app-layout>
