<x-app-layout>
     @php
        $user=Auth::user();
        
    @endphp
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 14px;
        }

        .rotary-card {
            border: 1px solid #aaa;
            padding: 20px;
            max-width: 700px;
            margin: 20px auto;
        }

        .profile-photo {
            width: 160px;
            height: auto;
            border: 1px solid #000;
        }

        .title {
            font-weight: bold;
            font-size: 18px;
        }

        .label {
            font-weight: bold;
        }

        .info td {
            padding: 3px 5px;
            vertical-align: top;
        }

        .contact-table td {
            border: 1px solid #000;
            padding: 5px;
            text-align: center;
        }

        .section-header {
            font-weight: bold;
            text-decoration: underline;
        }

        .border-box {
            border: 1px solid #000;
            padding: 4px;
        }
    </style>
    <x-slot name="header">
        <div class="bg-gradient-to-r from-yellow-400 via-orange-400 to-pink-500 py-6 rounded-md shadow-md">
        <h2 class="text-4xl font-extrabold text-center text-white drop-shadow-lg">
            {{$member->name}}
        </h2>
        </div>
    </x-slot>
<div class="max-w-3xl mx-auto mt-10 bg-white rounded-lg shadow-md p-8 ">
    <h2 class="text-3xl font-bold text-center text-lime-700 mb-6">Member Details</h2>

    

    <div class="rotary-card hidden md:block shadow-2xl">
    <div class="d-flex justify-content-between align-items-start ">
        <div class="mx-4 w-35 mt-3">
            <img src="{{ asset('images/rotary logo.png') }}" class="mx-4" alt="Rotary Logo" width="80">
            <p class="fw-bold mt-2">Rotary Club of Belgaum</p>
        </div>
        <div class="ms-4 flex-grow-1">
            <div class="title">{{$member->name}}</div>
            <div><strong>{{$member->sub_heading}}</strong></div>
            <table class="info mt-2 w-100 bg-gray-300">
                <tr><td class="label">Classification</td><td>: {{$member->profession}}</td></tr>
                <tr><td class="label">D.O.B.</td><td>: {{$member->dob}}</td></tr>
                <tr><td class="label">Wedding Anniversary</td><td>: {{$member->anniversary_date}}.</td></tr>
                <tr><td class="label">Blood Group</td><td>: {{$member->blood_group}}</td></tr>
            </table>
        </div>
    </div>
    <div class="d-flex justify-content-between align-items-start ">
    <div class="d-flex mt-2">
        <div class="mx-4">
            <img src="{{ asset('storage/' . $member->profile) }}" alt="Member Photo" class="profile-photo">
            <div class="mt-2">R.I. I.D. No. : <strong>{{$member->ri_id}}</strong></div>
        </div>

        <div class="ms-4 flex-grow-1">
            <table class="w-100 bg-gray-300 text-sm ">
                <tr>
                    <td class="label">Ann</td><td>: {{$member->ann}}</td>
                    <td class="label">D.O.B.</td><td>: {{$member->ann_dob}}</td>
                    <td class="label">Cell</td><td>: {{$member->ann_mobile_no}}</td>
                </tr>
            </table>
            <div class="mt-3 section-header">Annets</div>
            <table class="info w-100 bg-gray-300">
                <tr>
                    <td class="label">Annets</td><td>: {{$member->annette_1}}</td><td>{{$member->annette_2}}</td><td>{{$member->annette_3}}</td>
                </tr>
                <tr>
                    <td class="label">D.O.B.</td><td>: {{$member->annette_1_dob}}.</td><td>{{$member->annette_2_dob}}.</td><td>{{$member->annette_2_dob}}.</td>
                </tr>
            </table>
            <div class="mt-3 section-header">Addresses</div>
            <table class="info">
                <tr><td class="label">Residence</td><td>:{{$member->residential_address}}</td></tr>
                <tr><td class="label">Business</td><td>: {{$member->office_address}}</td></tr>
            </table>
        </div>
    </div>
    </div>

    <div class="mt-3">
        <table class="table contact-table">
            <tr class="fw-bold">
                <td>Telephone</td>
                <td>Mobile</td>
                <td>Email</td>
            </tr>
            <tr>
                
                <td>
                
                    <div>Office: 2431793</div>
                    <div>Residence: 2473747</div>
                </td>
                <td>{{$member->mobile}}</td>
                <td>{{$member->email}}</td>
            </tr>
        </table>
    </div>
</div>


    <div class="mt-6 text-center">
        <a href="{{ route('dashboard') }}" class="inline-block px-6 py-2 bg-lime-600 text-white rounded hover:bg-lime-700">Back to Dashboard</a>
    </div>
</div>




 {{-- MOBILE ONLY --}}
<div class="block md:hidden px-4 py-6">
        <div class="text-center mb-4">
            <h2 class="text-xl font-bold text-lime-700">Member Details (Mobile View)</h2>
        </div>

        <div class="bg-white shadow-lg rounded p-4 space-y-4">
            <div class="text-center">
                <img src="{{ asset('storage/' . $member->profile) }}" alt="Member" class="mx-auto rounded border w-24">
                <p class="mt-2 font-bold">{{$member->name}}</p>
                <p class="text-sm">{{$member->sub_heading}}</p>
                <p class="text-xs">{{$member->ri_id}}</p>
            </div>

            <div>
                <h4 class="font-semibold underline mb-1">Personal Info</h4>
                <ul class="text-sm">
                    <li><strong>Classification:</strong> {{$member->profession}}</li>
                    <li><strong>D.O.B.:</strong> {{$member->dob}}</li>
                    <li><strong>W.A.:</strong>  {{$member->anniversary_date}}</li>
                    <li><strong>Blood Group:</strong> {{$member->blood_group}}</li>
                </ul>
            </div>

            <div>
                <h4 class="font-semibold underline mb-1">Ann</h4>
                <ul class="text-sm">
                    <li><strong>Name:</strong> {{$member->ann}}</li>
                    <li><strong>D.O.B.:</strong>{{$member->ann_dob}}</li>
                    <li><strong>Cell:</strong> {{$member->ann_mobile_no}}</li>
                </ul>
            </div>

            <div>
                <h4 class="font-semibold underline mb-1">Annets</h4>
                <ul class="text-sm">
                    <li><strong>Names:</strong>{{$member->annette_1}}  {{$member->annette_2}}   {{$member->annette_2}}</li>
                    <li><strong>D.O.B.s:</strong> {{$member->annette_1_dob}} {{$member->annette_2_dob}} {{$member->annette_3_dob}}</li>
                </ul>
            </div>

            <div>
                <h4 class="font-semibold underline mb-1">Addresses</h4>
                <ul class="text-sm">
                    <li><strong>Residence:</strong>{{$member->residential_address}}</li>
                    <br/><li><strong>Business:</strong>{{$member->office_address}}</li>
                </ul>
            </div>

            <div>
                <h4 class="font-semibold underline mb-1">Contact</h4>
                <ul class="text-sm">
                    <li><strong>Office Tel:</strong> 2431793</li>
                    <li><strong>Res. Tel:</strong> 2473747</li>
                    <li><strong>Mobile:</strong> {{$member->mobile}}</li>
                    <li><strong>Email:</strong>{{$member->email}}</li>
                </ul>
            </div>

            <div class="text-center pt-4">
                <a href="{{ route('dashboard') }}" class="inline-block px-4 py-2 bg-lime-600 text-white rounded hover:bg-lime-700 text-sm">Back to Dashboard</a>
            </div>
        </div>
    </div>
</x-app-layout>