<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
        <script src="https://cdn.tailwindcss.com"></script>
         <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-..." crossorigin="anonymous">

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-gray-900 antialiased ">
        
        <div class="min-h-screen flex flex-col sm:justify-center items-center pt-0  bg-orange-100 dark:bg-gray-900">
             <div class="w-full flex items-center justify-between px-6 pt-3">
                <div class="text-blue-500 font-bold" style="font-family: 'Times New Roman', serif; font-size: 24px;">
                    <h1 class="fw-bold display-4 ">Rotary</h1>
                    <h1 class="ml-4 mx-5  display-6">Club Of Belgaum</h1>
                </div>

                <!-- Right: Logo -->
                <div>
                    <img src="{{ asset('images/logo.png') }}" alt="Logo" class="w-[150px] h-[150px] object-contain">
                </div>
            </div>
                


            <div>
                <a href="/">
                    {{-- <x-application-logo class="w-20 h-20 fill-current text-gray-500" /> --}}
                    <img src="{{ asset('images/rotary logo.png') }}" alt="Logo" class="w-[100px] h-[100px]">
                </a>
            </div>

            <div class="w-full sm:max-w-md mt-2 px-6 mb-2 py-4 bg-white dark:bg-gray-800 [box-shadow:0_20px_40px_rgba(0,0,255,0.5)] overflow-hidden sm:rounded-lg">
                {{ $slot }}
            </div>
            <div class="row m-0 h-30 w-full mt-2 bg-blue-800">
            <div class="col-12 p-4  text-white text-center">
                <h1 class="fw-bold display-4"> ROTARY CLUB DIRECTORY 2025</h1>
            </div>
        </div>
        </div>
        
    </body>
</html>
