<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\memberController;
use App\Http\Controllers\AuthController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', function () {
    return redirect()->route('login');
});
//Login by email OTP
Route::post('/send-otp', [AuthController::class, 'sendEmailOtp'])->name('send.otp');
Route::get('/verify-otp', [AuthController::class, 'showmailVerifyOtp'])->name('verify.show');
Route::post('/verify-otp', [AuthController::class, 'verifymailOtp'])->name('verify.otp');



//routes for sent otp for mobile
// Route::post('/send-otp', [AuthController::class, 'sendOtp'])->name('send.otp');
// Route::get('/verify-otp', [AuthController::class, 'showVerifyOtp'])->name('verify.show');
// Route::post('/verify-otp', [AuthController::class, 'verifyOtp'])->name('verify.otp');

// Route::get('/dashboard', function () {
//     return view('dashboard');
// })->middleware(['auth', 'verified'])->name('dashboard');

Route::post('/import-users', [MemberController::class, 'import'])->name('import.users');

Route::get('/dashboard', [MemberController::class, 'member_details']) ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::get('/member/{id}', [MemberController::class, 'show'])->name('more_details');



Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    
});

require __DIR__.'/auth.php';
